/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.data.fluid_generators;

import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.ordana.immersive_weathering.ImmersiveWeathering;
import com.ordana.immersive_weathering.data.fluid_generators.IFluidGenerator;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import net.mehvahdjukaar.moonlight.api.platform.PlatformHelper;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3414;
import net.minecraft.class_3609;
import net.minecraft.class_3611;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_5455;
import net.minecraft.class_6903;
import org.jetbrains.annotations.Nullable;

public class FluidGeneratorsHandler
extends class_4309 {
    public static final ImmutableList<class_2350> POSSIBLE_FLOW_DIRECTIONS = ImmutableList.of((Object)class_2350.field_11033, (Object)class_2350.field_11035, (Object)class_2350.field_11043, (Object)class_2350.field_11034, (Object)class_2350.field_11039);
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static final FluidGeneratorsHandler RELOAD_INSTANCE = new FluidGeneratorsHandler();
    private static final Map<class_2960, JsonElement> TO_PARSE = new HashMap<class_2960, JsonElement>();
    private static final Map<class_3611, ImmutableList<IFluidGenerator>> STILL_GENERATORS = new Object2ObjectOpenHashMap();
    private static final Map<class_3611, ImmutableList<IFluidGenerator>> FLOWING_GENERATORS = new Object2ObjectOpenHashMap();
    private static final Set<class_3611> HAS_GENERATOR = new HashSet<class_3611>();
    private boolean needsRefresh;

    public FluidGeneratorsHandler() {
        super(GSON, "fluid_generators");
    }

    protected void apply(Map<class_2960, JsonElement> jsons, class_3300 manager, class_3695 profile) {
        this.needsRefresh = true;
        TO_PARSE.clear();
        for (Map.Entry<class_2960, JsonElement> e : jsons.entrySet()) {
            TO_PARSE.put(e.getKey(), e.getValue().deepCopy());
        }
    }

    public void rebuild(class_5455 registryAccess) {
        if (this.needsRefresh) {
            this.needsRefresh = false;
            ArrayList generators = new ArrayList();
            for (Map.Entry<class_2960, JsonElement> e2 : TO_PARSE.entrySet()) {
                JsonElement json = e2.getValue();
                DataResult result = IFluidGenerator.CODEC.parse((DynamicOps)class_6903.method_40414((DynamicOps)JsonOps.INSTANCE, (class_5455)registryAccess), (Object)json);
                Optional o = result.resultOrPartial(error -> ImmersiveWeathering.LOGGER.error("Failed to read liquid generator JSON object for {} : {}", e2.getKey(), error));
                o.ifPresent(generators::add);
            }
            ImmersiveWeathering.LOGGER.info("Loaded {} liquid generators configurations", (Object)TO_PARSE.size());
            STILL_GENERATORS.clear();
            FLOWING_GENERATORS.clear();
            HAS_GENERATOR.clear();
            HashMap<class_3611, List> flowingMap = new HashMap<class_3611, List>();
            HashMap<class_3611, List> stillMap = new HashMap<class_3611, List>();
            for (IFluidGenerator g : generators) {
                List list;
                HAS_GENERATOR.add(g.getFluid());
                if (g.getFluidType().isFlowing()) {
                    list = flowingMap.computeIfAbsent(g.getFluid(), e -> new ArrayList());
                    list.add(g);
                    Collections.sort(list);
                }
                if (!g.getFluidType().isStill()) continue;
                list = stillMap.computeIfAbsent(g.getFluid(), e -> new ArrayList());
                list.add(g);
                Collections.sort(list);
            }
            flowingMap.forEach((key, value) -> FLOWING_GENERATORS.put((class_3611)key, (ImmutableList<IFluidGenerator>)ImmutableList.copyOf((Collection)value)));
            stillMap.forEach((key, value) -> STILL_GENERATORS.put((class_3611)key, (ImmutableList<IFluidGenerator>)ImmutableList.copyOf((Collection)value)));
            TO_PARSE.clear();
        }
    }

    public static Optional<Pair<class_2338, @Nullable class_3414>> applyGenerators(class_3609 fluid, List<class_2350> possibleFlowDir, class_2338 pos, class_1937 level) {
        class_3611 source = fluid.method_15751();
        if (HAS_GENERATOR.contains(source)) {
            ImmutableList<IFluidGenerator> list = level.method_8316(pos).method_15771() ? STILL_GENERATORS.get(source) : FLOWING_GENERATORS.get(source);
            return FluidGeneratorsHandler.generate(possibleFlowDir, pos, level, list);
        }
        return Optional.empty();
    }

    private static Optional<Pair<class_2338, @Nullable class_3414>> generate(List<class_2350> possibleFlowDir, class_2338 pos, class_1937 level, ImmutableList<IFluidGenerator> list) {
        if (list != null && !list.isEmpty()) {
            EnumMap<class_2350, class_2680> neighborCache = new EnumMap<class_2350, class_2680>(class_2350.class);
            for (IFluidGenerator generator : list) {
                Optional<class_2338> res = generator.tryGenerating(possibleFlowDir, pos, level, neighborCache);
                if (!res.isPresent()) continue;
                return res.map(a -> Pair.of((Object)a, (Object)generator.getSound()));
            }
        }
        return Optional.empty();
    }

    public void saveGeneartor(IFluidGenerator song) {
        File folder = PlatformHelper.getGamePath().resolve("test").toFile();
        if (!folder.exists()) {
            folder.mkdir();
        }
        File exportPath = new File(folder, "template.json");
        try (FileWriter writer = new FileWriter(exportPath);){
            this.writeToFile(song, writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void writeToFile(IFluidGenerator obj, FileWriter writer) {
        DataResult r = IFluidGenerator.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)obj);
        r.result().ifPresent(a -> GSON.toJson((JsonElement)this.sortJson(a.getAsJsonObject()), (Appendable)writer));
    }

    private JsonObject sortJson(JsonObject jsonObject) {
        try {
            TreeMap<String, JsonElement> joToMap = new TreeMap<String, JsonElement>();
            jsonObject.entrySet().forEach(e -> {
                JsonElement j = (JsonElement)e.getValue();
                if (j instanceof JsonObject) {
                    JsonObject jo = (JsonObject)j;
                    j = this.sortJson(jo);
                }
                joToMap.put((String)e.getKey(), j);
            });
            JsonObject sortedJSON = new JsonObject();
            joToMap.forEach((arg_0, arg_1) -> ((JsonObject)sortedJSON).add(arg_0, arg_1));
            return sortedJSON;
        }
        catch (Exception exception) {
            return jsonObject;
        }
    }
}

